/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.dita.dost.module.DebugAndFilterModule;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class DitaWriterFilter
extends AbstractXMLFilter {
    public static final String ATTRIBUTE_NAME_ORIG_FORMAT = "orig-format";
    private Map<QName, Map<String, String>> defaultValueMap = Map.of();
    private File outputFile;
    private Map<URI, Job.FileInfo> fileInfoMap;
    private TempFileNameScheme tempFileNameScheme;

    public void setTempFileNameScheme(TempFileNameScheme tempFileNameScheme) {
        this.tempFileNameScheme = tempFileNameScheme;
    }

    public void setDefaultValueMap(Map<QName, Map<String, String>> defaultMap) {
        this.defaultValueMap = defaultMap;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getContentHandler().endElement(uri, localName, qName);
    }

    @Override
    public void startDocument() throws SAXException {
        URI relativeToMap = URLUtils.getRelativePath(this.job.getInputFile(), this.currentFile);
        File path2Project = DebugAndFilterModule.getPathtoProject(URLUtils.toFile(relativeToMap), URLUtils.toFile(this.currentFile), URLUtils.toFile(this.job.getInputFile()), this.job);
        File path2rootmap = URLUtils.toFile(URLUtils.getRelativePath(this.currentFile, this.job.getInputFile())).getParentFile();
        this.getContentHandler().startDocument();
        if (!Constants.OS_NAME.toLowerCase().contains("windows")) {
            this.getContentHandler().processingInstruction("workdir", this.outputFile.getParentFile().getAbsolutePath());
        } else {
            this.getContentHandler().processingInstruction("workdir", "/" + this.outputFile.getParentFile().getAbsolutePath());
        }
        this.getContentHandler().ignorableWhitespace(new char[]{'\n'}, 0, 1);
        this.getContentHandler().processingInstruction("workdir-uri", this.outputFile.toURI().resolve(".").toString());
        this.getContentHandler().ignorableWhitespace(new char[]{'\n'}, 0, 1);
        if (path2Project != null) {
            this.getContentHandler().processingInstruction("path2project", path2Project.getPath() + File.separator);
            this.getContentHandler().processingInstruction("path2project-uri", URLUtils.toURI(path2Project).toString() + "/");
        } else {
            this.getContentHandler().processingInstruction("path2project", "");
            this.getContentHandler().processingInstruction("path2project-uri", "./");
        }
        if (path2rootmap != null) {
            this.getContentHandler().processingInstruction("path2rootmap-uri", URLUtils.toURI(path2rootmap).toString() + "/");
        } else {
            this.getContentHandler().processingInstruction("path2rootmap-uri", "./");
        }
        this.getContentHandler().ignorableWhitespace(new char[]{'\n'}, 0, 1);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Attributes res = this.processAttributes(qName, atts);
        this.getContentHandler().startElement(uri, localName, qName, res);
    }

    private Attributes processAttributes(String qName, Attributes atts) {
        AttributesImpl res = null;
        int attsLen = atts.getLength();
        for (int i = 0; i < attsLen; ++i) {
            String attName = atts.getLocalName(i);
            String origValue = atts.getValue(i);
            String attValue = null;
            if (!origValue.equals("-dita-use-conref-target")) {
                if ("conref".equals(attName)) {
                    if (res == null) {
                        res = new AttributesImpl(atts);
                    }
                    attValue = this.replaceHREF("conref", atts).toString();
                } else if ("href".equals(attName) || "copy-to".equals(attName)) {
                    if (DitaUtils.isLocalScope(atts.getValue("scope"))) {
                        if (res == null) {
                            res = new AttributesImpl(atts);
                        }
                        attValue = this.replaceHREF(attName, atts).toString();
                    }
                } else if ("format".equals(attName)) {
                    String format = atts.getValue("format");
                    String scope = atts.getValue("scope");
                    if (GenListModuleReader.isFormatDita(format) && DitaUtils.isLocalScope(scope)) {
                        if (res == null) {
                            res = new AttributesImpl(atts);
                        }
                        String string = attValue = Constants.MAPGROUP_D_MAPREF.matches(atts) ? "ditamap" : "dita";
                        if (!format.equals("dita")) {
                            XMLUtils.addOrSetAttribute(res, "http://dita-ot.sourceforge.net/ns/201007/dita-ot", ATTRIBUTE_NAME_ORIG_FORMAT, "dita-ot:orig-format", "CDATA", format);
                        }
                    }
                }
            }
            if (attValue == null) continue;
            XMLUtils.addOrSetAttribute(res, atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), attValue);
        }
        return Objects.requireNonNullElse(res, atts);
    }

    private String getAttributeValue(String elemQName, QName attQName, String value) {
        String defaultValue;
        Map<String, String> defaultMap;
        if (StringUtils.isEmptyString(value) && !this.defaultValueMap.isEmpty() && (defaultMap = this.defaultValueMap.get(attQName)) != null && (defaultValue = defaultMap.get(elemQName)) != null) {
            return defaultValue;
        }
        return value;
    }

    private URI replaceHREF(String attName, Attributes atts) {
        URI attValue = URLUtils.toURI(atts.getValue(attName));
        if (attValue != null) {
            String fragment = attValue.getFragment();
            if (fragment != null) {
                attValue = URLUtils.stripFragment(attValue);
            }
            if (attValue.toString().length() != 0) {
                URI current = this.currentFile.resolve(attValue);
                Job.FileInfo f = this.job.getFileInfo(current);
                if (f != null) {
                    Job.FileInfo cfi = this.job.getFileInfo(this.currentFile);
                    URI currrentFileTemp = this.job.tempDirURI.resolve(cfi.uri);
                    URI targetTemp = this.job.tempDirURI.resolve(f.uri);
                    attValue = URLUtils.getRelativePath(currrentFileTemp, targetTemp);
                } else if (this.tempFileNameScheme != null) {
                    URI relativePath;
                    URI currrentFileTemp = this.job.tempDirURI.resolve(this.tempFileNameScheme.generateTempFileName(this.currentFile));
                    URI targetTemp = this.job.tempDirURI.resolve(this.tempFileNameScheme.generateTempFileName(current));
                    attValue = relativePath = URLUtils.getRelativePath(currrentFileTemp, targetTemp);
                } else {
                    attValue = URLUtils.getRelativePath(this.currentFile, current);
                }
            }
            if (fragment != null) {
                attValue = URLUtils.setFragment(attValue, fragment);
            }
        } else {
            return null;
        }
        return attValue;
    }
}

