/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.brainstorm.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.ITopic;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchPolicyDescriptor;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTopicStructureCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMenu
extends MenuManager {
    private IGraphicalViewer viewer;

    public StructureMenu(IGraphicalViewer viewer) {
        super(MindMapMessages.Structure_text, "org.xmind.ui.brainstorm.structure");
        this.viewer = viewer;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructureMenu.this.fillMenu();
            }
        });
    }

    private void fillMenu() {
        List<IBranchPolicyDescriptor> descriptors = this.getCurrentStructures();
        if (descriptors == null) {
            return;
        }
        for (IBranchPolicyDescriptor descriptor : descriptors) {
            this.add((IAction)new StructureAction(descriptor));
        }
    }

    private List<IBranchPolicyDescriptor> getCurrentStructures() {
        if (this.viewer == null) {
            return null;
        }
        ArrayList list = null;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBranchPart branch;
                Object o = objectArray[n2];
                if (o instanceof ITopic && (branch = MindMapUtils.findBranch((IPart)this.viewer.findPart(o))) != null) {
                    List applicables = MindMapUI.getBranchPolicyManager().getApplicableBranchPolicyDescriptors(branch);
                    if (applicables.isEmpty()) {
                        return null;
                    }
                    if (list == null) {
                        list = new ArrayList(applicables);
                    } else {
                        list.retainAll(applicables);
                    }
                    if (list.isEmpty()) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StructureAction
    extends Action {
        private IBranchPolicyDescriptor descriptor;

        public StructureAction(IBranchPolicyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.setId("#" + descriptor.getId());
            this.setText(descriptor.getName());
            this.setImageDescriptor(descriptor.getIcon());
        }

        public void run() {
            if (StructureMenu.this.viewer == null) {
                return;
            }
            this.changeStructureClass(this.descriptor.getId());
        }

        private void changeStructureClass(String newStructureId) {
            EditDomain editDomain = StructureMenu.this.viewer.getEditDomain();
            if (editDomain == null) {
                return;
            }
            ICommandStack commandStack = editDomain.getCommandStack();
            if (commandStack == null) {
                return;
            }
            List<ITopic> topics = this.getTopics();
            if (topics != null && !topics.isEmpty()) {
                ModifyTopicStructureCommand command = new ModifyTopicStructureCommand(topics, newStructureId);
                command.setLabel(CommandMessages.Command_ModifyTopicStructure);
                commandStack.execute((Command)command);
            }
        }

        private List<ITopic> getTopics() {
            ISelection selection = StructureMenu.this.viewer.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return null;
            }
            Object[] elements = ((IStructuredSelection)selection).toArray();
            ArrayList<ITopic> list = new ArrayList<ITopic>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ITopic && !list.contains(o)) {
                    list.add((ITopic)o);
                }
                ++n2;
            }
            return list;
        }
    }
}

