/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.tests;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.xmind.core.audio.CoreAudio;
import org.xmind.core.audio.CoreAudioClient;
import org.xmind.core.audio.FileAudioTarget;
import org.xmind.core.audio.internal.device.RawDataRecorder;

public class RecordTestApplication
implements IApplication {
    private static final String LAME_RECORDER_ID = "org.xmind.audio.recorder.lame";

    public Object start(IApplicationContext context) throws Exception {
        RawDataRecorder.DEBUG = false;
        String targetFileName = Platform.getApplicationArgs()[0];
        File targetFile = new File(System.getProperty("user.home"), targetFileName);
        assert (CoreAudio.getService().isDeviceAvailable(LAME_RECORDER_ID));
        CoreAudioClient client = new CoreAudioClient(LAME_RECORDER_ID, null, new FileAudioTarget(targetFile));
        String sessionId = CoreAudio.getService().start(client);
        assert (sessionId != null);
        System.out.println("start recording for 5 seconds.....");
        int i = 0;
        while (i < 5) {
            assert (CoreAudio.getService().isSessionActive(sessionId));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            System.out.println("recording: " + (i + 1) + "s");
            ++i;
        }
        System.out.println("about to stop recording");
        assert (CoreAudio.getService().isSessionActive(sessionId));
        CoreAudio.getService().stop(sessionId);
        assert (!CoreAudio.getService().isSessionActive(sessionId));
        System.out.println("recording stopped");
        assert (targetFile.exists());
        System.out.println("Successfully recorded to " + targetFile.getAbsolutePath());
        return EXIT_OK;
    }

    public void stop() {
    }
}

