/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

public class Codec {
    public static final String HASH_ALGORITHM = "SHA-256";

    private Codec() {
    }

    public static char[] hexEncode(byte[] bytes, boolean upperCase) {
        int bytesLength = bytes.length;
        char[] chars = new char[bytesLength << 1];
        int byteIndex = 0;
        int charIndex = 0;
        while (byteIndex < bytesLength) {
            int value = bytes[byteIndex++] & 0xFF;
            char c = Character.forDigit(value >> 4, 16);
            if (upperCase) {
                c = Character.toUpperCase(c);
            }
            chars[charIndex++] = c;
            c = Character.forDigit(value & 0xF, 16);
            if (upperCase) {
                c = Character.toUpperCase(c);
            }
            chars[charIndex++] = c;
        }
        return chars;
    }

    public static byte[] hexDecode(char[] chars) {
        int charsLength = chars.length;
        if ((charsLength & 1) != 0) {
            throw new IllegalArgumentException("Invalid hex length: " + charsLength);
        }
        byte[] bytes = new byte[charsLength >> 1];
        int charIndex = 0;
        int byteIndex = 0;
        while (charIndex < charsLength) {
            int value2;
            int value1 = Character.digit(chars[charIndex], 16);
            if (value1 < 0) {
                throw new IllegalArgumentException("Invalid character '" + chars[charIndex] + "' at index " + charIndex);
            }
            if ((value2 = Character.digit(chars[++charIndex], 16)) < 0) {
                throw new IllegalArgumentException("Invalid character '" + chars[charIndex] + "' at index " + charIndex);
            }
            ++charIndex;
            bytes[byteIndex++] = (byte)((value1 << 4 | value2) & 0xFF);
        }
        return bytes;
    }
}

