/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.event.MouseEvent;
import org.xmind.ui.gantt.GanttDialogPart;
import org.xmind.ui.gantt2.gefext.AbstractTracker;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.util.MindMapUtils;

public abstract class TaskTreeEditableTracker
extends AbstractTracker {
    protected static final Color invalidColor = Display.getCurrent().getSystemColor(16);
    protected static final Color validColor = Display.getCurrent().getSystemColor(2);
    protected IFigure target;
    protected FigureCanvas canvas;
    protected ITopic topic;
    protected TaskTreeItemPart host;

    public TaskTreeEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        this.target = target;
        this.canvas = canvas;
        this.topic = host.getTask();
        this.host = host;
    }

    public boolean handleMouseDown(MouseEvent me, IViewer viewer) {
        this.edit();
        this.postStartEditing();
        return super.handleMouseDown(me, viewer);
    }

    protected abstract void edit();

    protected void locateEditor(final Control editor, final IFigure item, final Viewport viewport) {
        if (editor == null || item == null || viewport == null) {
            return;
        }
        Rectangle r = new Rectangle(item.getBounds());
        --r.y;
        ++r.height;
        Point origin = viewport.getViewLocation();
        editor.setBounds(r.x - origin.x, r.y - origin.y, r.width, r.height);
        final PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Rectangle r = item.getBounds();
                Point origin = viewport.getViewLocation();
                editor.setBounds(r.x - origin.x, r.y - origin.y, r.width, r.height);
            }
        };
        final FigureListener figureListener = new FigureListener(){

            public void figureMoved(IFigure source) {
                Rectangle r = item.getBounds();
                Point origin = viewport.getViewLocation();
                editor.setBounds(r.x - origin.x, r.y - origin.y, r.width, r.height);
            }
        };
        viewport.getHorizontalRangeModel().addPropertyChangeListener(listener);
        viewport.getVerticalRangeModel().addPropertyChangeListener(listener);
        item.addFigureListener(figureListener);
        editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (viewport != null) {
                    viewport.getHorizontalRangeModel().removePropertyChangeListener(listener);
                    viewport.getVerticalRangeModel().removePropertyChangeListener(listener);
                }
                if (item != null) {
                    item.removeFigureListener(figureListener);
                }
            }
        });
    }

    protected ICommandStack getCommandStack() {
        return this.topic == null ? ICommandStack.NULL : MindMapUtils.getCommandStack((IWorkbook)this.topic.getOwnedWorkbook());
    }

    protected void setActiveEditor(Control activeEditor) {
        if (this.host != null) {
            this.host.setActiveEditor(activeEditor);
        }
    }

    protected void postStartEditing() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                TaskTreeEditableTracker.this.changeActiveTool("edit tool");
                            }
                        });
                    }
                });
            }
        });
    }

    protected void preCancelEditing() {
        this.changeActiveTool("default tool");
    }

    protected void postCancelEditing() {
        this.changeActiveTool("default tool");
    }

    private void changeActiveTool(String toolType) {
        Object obj;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MPart part = E4Utils.findPart((IWorkbenchWindow)window, (String)"org.xmind.ui.dialogPart.gantt");
        if (part != null && (obj = part.getObject()) instanceof GanttDialogPart) {
            GanttViewer viewer = ((GanttDialogPart)((Object)obj)).getCurrentViewer();
            if (viewer == null) {
                return;
            }
            GanttEditDomain editDomain = viewer.getEditDomain();
            if (editDomain == null) {
                return;
            }
            editDomain.setActiveTool(toolType);
        }
    }
}

