/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class DatePanelLayout
extends AbstractLayout {
    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int height;
        int width;
        if (wHint >= 0 && hHint >= 0) {
            return new Dimension(wHint, hHint);
        }
        List children = container.getChildren();
        int cols = 7;
        int rows = (children.size() + 6) / cols;
        int[] widths = wHint >= 0 ? null : new int[cols];
        int[] heights = hHint >= 0 ? null : new int[rows];
        int m = 0;
        int n = 0;
        int wh = wHint >= 0 ? wHint / cols : -1;
        int hh = hHint >= 0 ? hHint / rows : -1;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize(wh, hh);
            if (wHint < 0) {
                widths[m] = Math.max(widths[m], childSize.width);
            }
            if (hHint < 0) {
                heights[n] = Math.max(heights[n], childSize.height);
            }
            if (++m >= cols) {
                ++n;
                m = 0;
            }
            ++i;
        }
        if (wHint >= 0) {
            width = wHint;
        } else {
            width = 0;
            int i2 = 0;
            while (i2 < widths.length) {
                width += widths[i2];
                ++i2;
            }
        }
        if (hHint >= 0) {
            height = hHint;
        } else {
            height = 0;
            int i3 = 0;
            while (i3 < heights.length) {
                height += heights[i3];
                ++i3;
            }
        }
        return new Dimension(width, height);
    }

    public void layout(IFigure container) {
        Rectangle box = container.getClientArea();
        List children = container.getChildren();
        int cols = 7;
        int rows = (children.size() + 6) / cols;
        float fx = box.x;
        float fy = box.y;
        float fw = ((float)box.width + 0.99f) / (float)cols;
        float fh = ((float)box.height + 0.99f) / (float)rows;
        int x = box.x;
        int y = box.y;
        int w = (int)(fx + fw) - x;
        int h = (int)(fy + fh) - y;
        int m = 0;
        int n = 0;
        int[] lefts = new int[7];
        int[] widths = new int[7];
        int i = 0;
        while (i < children.size()) {
            Rectangle b;
            IFigure child = (IFigure)children.get(i);
            if (n == 0) {
                b = new Rectangle(x, y, w, h);
                lefts[m] = x;
                widths[m] = w;
                w = (int)((fx += fw) + fw) - (x += w);
            } else {
                x = lefts[m];
                w = widths[m];
                b = new Rectangle(x, y, w, h);
            }
            child.setBounds(b);
            if (++m >= cols) {
                h = (int)((fy += fh) + fh) - (y += h);
                ++n;
                m = 0;
            }
            ++i;
        }
    }
}

