/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.xmind.ui.IWordContext;
import org.xmind.ui.IWordContextProvider;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.internal.spelling.SpellingPlugin;

@Deprecated
public class SpellingCheckView
extends ViewPart
implements IJobChangeListener,
IPartListener {
    private Composite composite;
    private PageBook bannerBar;
    private Control buttonBar;
    private Control statusBar;
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.createBannerBar(this.composite);
        this.createResultViewer(this.composite);
        if (SpellingViewContent.getInstance().getInput() != null) {
            this.viewer.setInput((Object)SpellingViewContent.getInstance().getInput());
        }
        SpellingViewContent.getInstance().addView(this);
        if (CheckSpellingJob.isRunning()) {
            this.showScanning();
        } else {
            this.showButtons();
        }
        CheckSpellingJob.getInstance().addJobChangeListener(this);
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private void createBannerBar(Composite parent) {
        this.bannerBar = new PageBook(parent, 0);
        this.bannerBar.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createButtonBar((Composite)this.bannerBar);
        this.createStatusBar((Composite)this.bannerBar);
    }

    private void createButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        this.buttonBar = buttonBar;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 5;
        buttonBar.setLayout((Layout)layout);
        Button scanAllButton = new Button(buttonBar, 8);
        scanAllButton.setText(Messages.SpellingCheckView_button_ScanAllWorkbooks);
        scanAllButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        scanAllButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SpellingCheckView.this.scanAll();
            }
        });
        Button scanButton = new Button(buttonBar, 8);
        scanButton.setText(Messages.SpellingCheckView_button_ScanWorkbook);
        scanButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        scanButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SpellingCheckView.this.scanWorkbook();
            }
        });
    }

    private void createStatusBar(Composite parent) {
        Composite statusBar = new Composite(parent, 0);
        this.statusBar = statusBar;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        statusBar.setLayout((Layout)layout);
        Label label = new Label(statusBar, 0x1000000);
        label.setText(Messages.SpellingCheckView_Scanning);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
    }

    private void createResultViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 67588);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        TreeColumn col1 = new TreeColumn(this.viewer.getTree(), 0);
        col1.setText(Messages.SpellingCheckView_column_Word);
        col1.setWidth(150);
        TreeColumn col2 = new TreeColumn(this.viewer.getTree(), 0);
        col2.setText(Messages.SpellingCheckView_column_Suggestions);
        col2.setWidth(220);
        this.viewer.setContentProvider((IContentProvider)new SpellingCheckContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SpellingCheckLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new WordDoubleClickListener());
        this.viewer.setAutoExpandLevel(-1);
        new SuggestionMenu(this.viewer);
    }

    private void showScanning() {
        this.bannerBar.showPage(this.statusBar);
    }

    private void showButtons() {
        this.bannerBar.showPage(this.buttonBar);
    }

    public void scanAll() {
        IEditorReference[] ers = this.getSite().getPage().getEditorReferences();
        if (ers.length == 0) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.SpellingCheckView_dialogTitle, (String)Messages.SpellingCheckView_NoEditors_message);
            return;
        }
        SpellingCheckViewerInput input = new SpellingCheckViewerInput();
        IEditorReference[] iEditorReferenceArray = ers;
        int n = ers.length;
        int n2 = 0;
        while (n2 < n) {
            IWordContextProvider provider;
            IEditorReference er = iEditorReferenceArray[n2];
            IEditorPart editor = er.getEditor(false);
            if (editor != null && (provider = (IWordContextProvider)editor.getAdapter(IWordContextProvider.class)) != null) {
                input.elements.add(new WorkbookItem(input, editor, provider));
            }
            ++n2;
        }
        if (input.elements.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.SpellingCheckView_dialogTitle, (String)Messages.SpellingCheckView_NoProviders_message);
        } else {
            CheckSpellingJob.start(input);
        }
    }

    public void scanWorkbook() {
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor == null) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.SpellingCheckView_dialogTitle, (String)Messages.SpellingCheckView_NoEditors_message);
            return;
        }
        IWordContextProvider provider = (IWordContextProvider)editor.getAdapter(IWordContextProvider.class);
        if (provider == null) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.SpellingCheckView_dialogTitle, (String)Messages.SpellingCheckView_NoProviders_message);
        } else {
            SpellingCheckViewerInput input = new SpellingCheckViewerInput();
            input.elements.add(new WorkbookItem(input, editor, provider));
            CheckSpellingJob.start(input);
        }
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        SpellingViewContent.getInstance().removeView(this);
        CheckSpellingJob.getInstance().removeJobChangeListener(this);
        super.dispose();
    }

    public void aboutToRun(IJobChangeEvent event) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SpellingCheckView.this.showScanning();
            }
        });
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(final IJobChangeEvent event) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SpellingCheckView.this.showButtons();
                if (event.getResult().isOK()) {
                    SpellingViewContent.getInstance().setInput(((CheckSpellingJob)event.getJob()).getInput());
                }
            }
        });
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void inputChanged(SpellingCheckViewerInput input) {
        this.viewer.setInput((Object)input);
    }

    public void update(Object element) {
        this.viewer.refresh(element);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        SpellingCheckViewerInput input = SpellingViewContent.getInstance().getInput();
        if (input != null) {
            Object[] workbookItems;
            Object[] objectArray = workbookItems = input.elements.toArray();
            int n = workbookItems.length;
            int n2 = 0;
            while (n2 < n) {
                Object workbookItem = objectArray[n2];
                WorkbookItem item = (WorkbookItem)workbookItem;
                if (item.editor == part) {
                    input.elements.remove(item);
                    SpellingViewContent.getInstance().update(input);
                }
                ++n2;
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private static class AddToDictionaryAction
    extends Action {
        private WordItem item;

        public AddToDictionaryAction(WordItem item) {
            this.item = item;
            this.setText(Messages.addToDictionary);
        }

        public void run() {
            SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

                public void handleWith(SpellChecker spellChecker) {
                    spellChecker.addToDictionary(((AddToDictionaryAction)AddToDictionaryAction.this).item.invalidWord);
                    Object toUpdate = ((AddToDictionaryAction)AddToDictionaryAction.this).item.parent;
                    ((AddToDictionaryAction)AddToDictionaryAction.this).item.parent.children.remove(AddToDictionaryAction.this.item);
                    if (((AddToDictionaryAction)AddToDictionaryAction.this).item.parent.children.isEmpty()) {
                        toUpdate = ((AddToDictionaryAction)AddToDictionaryAction.this).item.parent.parent;
                        ((AddToDictionaryAction)AddToDictionaryAction.this).item.parent.parent.children.remove(((AddToDictionaryAction)AddToDictionaryAction.this).item.parent);
                    }
                    SpellingViewContent.getInstance().update(toUpdate);
                }
            });
        }
    }

    private static class CheckSpellingJob
    extends Job
    implements SpellCheckListener {
        private static final CheckSpellingJob instance = new CheckSpellingJob();
        private SpellingCheckViewerInput input = null;
        private SpellChecker spellChecker = null;
        private WordContextItem currentWordContextItem = null;

        private CheckSpellingJob() {
            super(Messages.CheckSpellingJob_name);
        }

        public void setInput(SpellingCheckViewerInput input) {
            this.input = input;
        }

        public SpellingCheckViewerInput getInput() {
            return this.input;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.spellChecker = null;
            SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

                public void handleWith(SpellChecker theSpellChecker) {
                    CheckSpellingJob.this.spellChecker = theSpellChecker;
                }
            });
            while (this.spellChecker == null) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask(Messages.CheckSpellingJob_task_Scanning, this.input.elements.size());
            SpellChecker theSpellChecker = this.spellChecker;
            theSpellChecker.addSpellCheckListener((SpellCheckListener)this);
            try {
                for (WorkbookItem item : this.input.elements) {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.subTask(item.editor.getTitle());
                    this.scan((IProgressMonitor)new SubProgressMonitor(monitor, 1), item);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.worked(1);
                }
            }
            finally {
                theSpellChecker.removeSpellCheckListener((SpellCheckListener)this);
            }
            monitor.done();
            SpellingPlugin.getDefault().getUsageDataCollector().increase("SpellingCheckCount");
            return Status.OK_STATUS;
        }

        private void scan(IProgressMonitor monitor, WorkbookItem parent) {
            List<IWordContext> contexts = parent.provider.getWordContexts();
            monitor.beginTask(null, contexts.size());
            for (IWordContext context : contexts) {
                if (monitor.isCanceled()) {
                    return;
                }
                WordContextItem item = new WordContextItem(parent, context);
                monitor.subTask(String.valueOf(parent.editor.getTitle()) + " - " + item.context.getName());
                this.scan((IProgressMonitor)new SubProgressMonitor(monitor, 1), item);
                if (monitor.isCanceled()) {
                    return;
                }
                if (!item.children.isEmpty()) {
                    parent.children.add(item);
                }
                monitor.worked(1);
            }
            monitor.done();
        }

        private void scan(IProgressMonitor monitor, WordContextItem parent) {
            monitor.beginTask(null, 1);
            String content = parent.context.getContent();
            if (monitor.isCanceled()) {
                return;
            }
            this.currentWordContextItem = parent;
            this.spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer(content));
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }

        public void spellingError(SpellCheckEvent event) {
            this.currentWordContextItem.children.add(new WordItem(this.currentWordContextItem, event));
        }

        public static CheckSpellingJob getInstance() {
            return instance;
        }

        public static void start(SpellingCheckViewerInput input) {
            instance.setInput(input);
            instance.schedule();
        }

        public static boolean isRunning() {
            return instance.getState() == 4;
        }
    }

    private static class NoSpellingErrorItem {
        public WorkbookItem parent;

        public NoSpellingErrorItem(WorkbookItem parent) {
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NoSpellingErrorItem)) {
                return false;
            }
            return ((NoSpellingErrorItem)obj).parent == this.parent;
        }
    }

    private static class ReplaceAction
    extends Action {
        private WordItem item;
        private String suggestion;

        public ReplaceAction(WordItem item, String suggestion) {
            this.item = item;
            this.suggestion = suggestion;
            this.setText(String.valueOf(item.invalidWord) + " -> " + suggestion);
        }

        public void run() {
            if (this.item.parent.context.replaceWord(this.item.start, this.item.invalidWord.length(), this.suggestion)) {
                Object toUpdate = this.item.parent;
                this.item.parent.children.remove(this.item);
                if (this.item.parent.children.isEmpty()) {
                    toUpdate = this.item.parent.parent;
                    this.item.parent.parent.children.remove(this.item.parent);
                } else {
                    int offset = this.suggestion.length() - this.item.invalidWord.length();
                    if (offset != 0) {
                        for (WordItem sibling : this.item.parent.children) {
                            if (sibling.start <= this.item.start) continue;
                            sibling.start += offset;
                        }
                    }
                }
                SpellingViewContent.getInstance().update(toUpdate);
            }
        }
    }

    private static class SpellingCheckContentProvider
    implements ITreeContentProvider {
        private SpellingCheckContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof WorkbookItem) {
                WorkbookItem item = (WorkbookItem)parentElement;
                if (item.children.isEmpty()) {
                    return new Object[]{new NoSpellingErrorItem(item)};
                }
                return item.children.toArray();
            }
            if (parentElement instanceof WordContextItem) {
                return ((WordContextItem)parentElement).children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof WordItem) {
                return ((WordItem)element).parent;
            }
            if (element instanceof WordContextItem) {
                return ((WordContextItem)element).parent;
            }
            if (element instanceof WorkbookItem) {
                return ((WorkbookItem)element).parent;
            }
            if (element instanceof NoSpellingErrorItem) {
                return ((NoSpellingErrorItem)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof WorkbookItem) {
                return true;
            }
            if (element instanceof WordContextItem) {
                return !((WordContextItem)element).children.isEmpty();
            }
            if (element instanceof SpellingCheckViewerInput) {
                return !((SpellingCheckViewerInput)element).elements.isEmpty();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SpellingCheckViewerInput) {
                return ((SpellingCheckViewerInput)inputElement).elements.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class SpellingCheckLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

        private SpellingCheckLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof WordContextItem) {
                if (columnIndex == 0) {
                    return this.getImageFor(((WordContextItem)element).context.getIcon());
                }
            } else if (element instanceof WorkbookItem && columnIndex == 0) {
                return ((WorkbookItem)element).editor.getTitleImage();
            }
            return null;
        }

        private Image getImageFor(ImageDescriptor icon) {
            if (icon == null) {
                return null;
            }
            Image image = this.images.get(icon);
            if (image == null) {
                image = icon.createImage();
                this.images.put(icon, image);
            }
            return image;
        }

        public void dispose() {
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images.clear();
            super.dispose();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof WordItem) {
                WordItem item = (WordItem)element;
                if (columnIndex == 0) {
                    return item.invalidWord;
                }
                StringBuffer sb = new StringBuffer(item.suggestions.size() * 10);
                for (Object s : item.suggestions) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(s.toString());
                }
                return sb.toString();
            }
            if (element instanceof WordContextItem) {
                if (columnIndex == 0) {
                    return ((WordContextItem)element).context.getName();
                }
            } else if (element instanceof WorkbookItem) {
                if (columnIndex == 0) {
                    return ((WorkbookItem)element).editor.getTitle();
                }
            } else if (element instanceof NoSpellingErrorItem && columnIndex == 0) {
                return Messages.SpellingCheckView_NoSpellingError_text;
            }
            return "";
        }
    }

    private static class SpellingCheckViewerInput {
        public List<WorkbookItem> elements = new ArrayList<WorkbookItem>();

        private SpellingCheckViewerInput() {
        }
    }

    private static class SpellingViewContent {
        private static final SpellingViewContent instance = new SpellingViewContent();
        private SpellingCheckViewerInput input = null;
        private List<SpellingCheckView> views = new ArrayList<SpellingCheckView>();

        private SpellingViewContent() {
        }

        public void addView(SpellingCheckView view) {
            this.views.add(view);
        }

        public void removeView(SpellingCheckView view) {
            this.views.remove((Object)view);
        }

        public void setInput(SpellingCheckViewerInput input) {
            this.input = input;
            this.fireInputChanged();
        }

        public SpellingCheckViewerInput getInput() {
            return this.input;
        }

        private void fireInputChanged() {
            Object[] objectArray = this.views.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object view = objectArray[n2];
                ((SpellingCheckView)((Object)view)).inputChanged(this.input);
                ++n2;
            }
        }

        public void update(Object element) {
            Object[] objectArray = this.views.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object view = objectArray[n2];
                ((SpellingCheckView)((Object)view)).update(element);
                ++n2;
            }
        }

        public static SpellingViewContent getInstance() {
            return instance;
        }
    }

    private static class SuggestionMenu
    implements DisposeListener,
    IMenuListener {
        private TreeViewer viewer;
        private MenuManager menu;

        public SuggestionMenu(TreeViewer viewer) {
            this.viewer = viewer;
            this.menu = new MenuManager();
            this.menu.addMenuListener((IMenuListener)this);
            this.menu.setRemoveAllWhenShown(true);
            viewer.getTree().setMenu(this.menu.createContextMenu((Control)viewer.getTree()));
            viewer.getTree().addDisposeListener((DisposeListener)this);
        }

        public void menuAboutToShow(IMenuManager manager) {
            Object o;
            if (manager != this.menu) {
                return;
            }
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) != null && o instanceof WordItem) {
                this.fillMenu((IMenuManager)this.menu, (WordItem)o);
            }
        }

        private void fillMenu(IMenuManager menu, WordItem item) {
            for (Object suggestion : item.suggestions) {
                menu.add((IAction)new ReplaceAction(item, suggestion.toString()));
            }
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new AddToDictionaryAction(item));
        }

        public void widgetDisposed(DisposeEvent e) {
            this.menu.dispose();
        }
    }

    private static class WordContextItem {
        public WorkbookItem parent;
        public IWordContext context;
        public List<WordItem> children = new ArrayList<WordItem>();

        public WordContextItem(WorkbookItem parent, IWordContext context) {
            this.parent = parent;
            this.context = context;
        }
    }

    private static class WordDoubleClickListener
    implements IDoubleClickListener {
        private WordDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection() instanceof IStructuredSelection) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof WordItem) {
                    ((WordItem)element).reveal();
                } else if (element instanceof WordContextItem) {
                    ((WordContextItem)element).context.reveal();
                } else if (element instanceof WorkbookItem) {
                    IEditorPart editor = ((WorkbookItem)element).editor;
                    editor.getSite().getPage().activate((IWorkbenchPart)editor);
                }
            }
        }
    }

    private static class WordItem {
        public WordContextItem parent;
        public int start;
        public String invalidWord;
        public List suggestions;

        public WordItem(WordContextItem parent, SpellCheckEvent range) {
            this.parent = parent;
            this.start = range.getWordContextPosition();
            this.invalidWord = range.getInvalidWord();
            this.suggestions = range.getSuggestions();
        }

        public void reveal() {
            this.parent.context.revealWord(this.start, this.invalidWord.length());
        }
    }

    private static class WorkbookItem {
        public SpellingCheckViewerInput parent;
        public IEditorPart editor;
        public IWordContextProvider provider;
        public List<WordContextItem> children = new ArrayList<WordContextItem>();

        public WorkbookItem(SpellingCheckViewerInput parent, IEditorPart editor, IWordContextProvider provider) {
            this.parent = parent;
            this.editor = editor;
            this.provider = provider;
        }
    }
}

