/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.tools;

import java.io.IOException;
import org.eclipse.core.runtime.Platform;

public class QuickOpenHelper {
    private static QuickOpenHelper instance = null;
    private Process process;

    public boolean canShow() {
        return "macosx".equals(Platform.getOS());
    }

    public void show(String ... paths) {
        Process proc;
        this.hide();
        String[] commands = new String[paths.length + 2];
        commands[0] = "qlmanage";
        commands[1] = "-p";
        System.arraycopy(paths, 0, commands, 2, paths.length);
        try {
            proc = Runtime.getRuntime().exec(commands);
        }
        catch (IOException iOException) {
            return;
        }
        this.process = proc;
    }

    public boolean isOpen() {
        if (this.process == null) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
    }

    public void hide() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public static QuickOpenHelper getInstance() {
        if (instance == null) {
            instance = new QuickOpenHelper();
        }
        return instance;
    }
}

