/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IWorkbook;
import org.xmind.ui.dialogs.IDialogConstants;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.wizards.WorkbookImporter;
import org.xmind.ui.wizards.AbstractMindMapImportPage;
import org.xmind.ui.wizards.AbstractMindMapImportWizard;
import org.xmind.ui.wizards.MindMapImporter;

public class WorkbookImportWizard
extends AbstractMindMapImportWizard {
    private static final String SETTINGS_ID = "org.xmind.ui.imports.workbook";
    private static final String PAGE_ID = "importWorkbook";
    private WorkbookImportPage page;

    public WorkbookImportWizard() {
        IDialogSettings settings = MindMapUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_ID);
        if (settings == null) {
            settings = MindMapUIPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_ID);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(MindMapMessages.WorkbookImportWizard_ImportWorkbook_Title);
    }

    public void addPages() {
        this.page = new WorkbookImportPage();
        this.addPage((IWizardPage)this.page);
    }

    @Override
    protected MindMapImporter createImporter(String sourcePath, IWorkbook targetWorkbook) {
        return new WorkbookImporter(sourcePath, targetWorkbook);
    }

    @Override
    protected String getApplicationId() {
        return "XMind Workbook";
    }

    @Override
    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    @Override
    public boolean isToNewWorkbook() {
        return false;
    }

    private class WorkbookImportPage
    extends AbstractMindMapImportPage {
        protected WorkbookImportPage() {
            super(WorkbookImportWizard.PAGE_ID, MindMapMessages.WorkbookImportWizard_ImportXmindMap_Title);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.updateStatus();
            if (this.getCastedWizard().hasTargetWorkbook()) {
                parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WorkbookImportPage.this.openBrowseDialog();
                    }
                });
            } else {
                this.disableControls(fileGroup);
                this.setMessage(MindMapMessages.WorkbookImportWizard_NoTargetWorkbookMessage, 2);
            }
        }

        private void disableControls(Control control) {
            control.setEnabled(false);
            if (control instanceof Composite) {
                Control[] controls = ((Composite)control).getChildren();
                int i = 0;
                while (i < controls.length) {
                    this.disableControls(controls[i]);
                    ++i;
                }
            }
        }

        @Override
        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            dialog.setFilterExtensions(new String[]{"*.xmind"});
            dialog.setFilterNames(new String[]{NLS.bind((String)"{0} (*{1})", (Object)IDialogConstants.FILE_DIALOG_FILTER_WORKBOOK, (Object)".xmind")});
            return dialog;
        }

        @Override
        protected boolean isPageCompletable() {
            return super.isPageCompletable() && this.getCastedWizard().hasTargetWorkbook();
        }
    }
}

