/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.internal.artifacts.dsl.DependencyHandlerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.initialization.transform.BaseInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.ExternalDependencyInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.ProjectDependencyInstrumentingArtifactTransform;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.component.local.model.TransformedComponentFileArtifactIdentifier;
import org.gradle.util.GradleVersion;

public class DefaultScriptClassPathResolver
implements ScriptClassPathResolver {
    private static final Set<DependencyFactoryInternal.ClassPathNotation> GRADLE_API_NOTATIONS = EnumSet.of(DependencyFactoryInternal.ClassPathNotation.GRADLE_API, DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY);
    private static final Attribute<Boolean> HIERARCHY_COLLECTED_ATTRIBUTE = Attribute.of((String)"org.gradle.internal.hierarchy-collected", Boolean.class);
    public static final Attribute<String> INSTRUMENTED_ATTRIBUTE = Attribute.of((String)"org.gradle.internal.instrumented", String.class);
    public static final String NOT_INSTRUMENTED_ATTRIBUTE_VALUE = "not-instrumented";
    private static final String INSTRUMENTED_EXTERNAL_DEPENDENCY_ATTRIBUTE = "instrumented-external-dependency";
    private static final String INSTRUMENTED_PROJECT_DEPENDENCY_ATTRIBUTE = "instrumented-project-dependency";
    private final NamedObjectInstantiator instantiator;
    private final AgentStatus agentStatus;

    public DefaultScriptClassPathResolver(NamedObjectInstantiator instantiator, AgentStatus agentStatus) {
        this.instantiator = instantiator;
        this.agentStatus = agentStatus;
    }

    @Override
    public void prepareDependencyHandler(DependencyHandler dependencyHandler) {
        ((DependencyHandlerInternal)dependencyHandler).getDefaultArtifactAttributes().attribute(INSTRUMENTED_ATTRIBUTE, (Object)NOT_INSTRUMENTED_ATTRIBUTE_VALUE).attribute(HIERARCHY_COLLECTED_ATTRIBUTE, (Object)false);
        this.registerTransform(dependencyHandler, ExternalDependencyInstrumentingArtifactTransform.class, INSTRUMENTED_EXTERNAL_DEPENDENCY_ATTRIBUTE);
        this.registerTransform(dependencyHandler, ProjectDependencyInstrumentingArtifactTransform.class, INSTRUMENTED_PROJECT_DEPENDENCY_ATTRIBUTE);
    }

    private void registerTransform(DependencyHandler dependencyHandler, Class<? extends BaseInstrumentingArtifactTransform> transform, String instrumentedAttribute) {
        dependencyHandler.registerTransform(transform, spec -> {
            spec.getFrom().attribute(INSTRUMENTED_ATTRIBUTE, (Object)NOT_INSTRUMENTED_ATTRIBUTE_VALUE);
            spec.getTo().attribute(INSTRUMENTED_ATTRIBUTE, (Object)instrumentedAttribute);
            spec.parameters(parameters -> parameters.getAgentSupported().set((Object)this.agentStatus.isAgentInstrumentationEnabled()));
        });
    }

    @Override
    public void prepareClassPath(Configuration configuration, DependencyHandler dependencyHandler) {
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.instantiator.named(Usage.class, "java-runtime")));
        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.instantiator.named(Category.class, "library")));
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.instantiator.named(LibraryElements.class, "jar")));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.instantiator.named(Bundling.class, "external")));
        attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)Integer.parseInt(JavaVersion.current().getMajorVersion()));
        attributes.attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE, (Object)((GradlePluginApiVersion)this.instantiator.named(GradlePluginApiVersion.class, GradleVersion.current().getVersion())));
        configuration.getDependencyConstraints().add((Object)dependencyHandler.getConstraints().create((Object)"org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
            version.require("2.17.1");
            version.reject(new String[]{"[2.0, 2.17.1)"});
        })));
    }

    @Override
    public ClassPath resolveClassPath(Configuration classpathConfiguration) {
        ArtifactCollection instrumentedExternalDependencies = DefaultScriptClassPathResolver.getInstrumentedExternalDependencies(classpathConfiguration);
        ArtifactCollection instrumentedProjectDependencies = DefaultScriptClassPathResolver.getInstrumentedProjectDependencies(classpathConfiguration);
        ClassPath classPath = DefaultScriptClassPathResolver.combineToClasspath(classpathConfiguration, instrumentedExternalDependencies, instrumentedProjectDependencies);
        return TransformedClassPath.handleInstrumentingArtifactTransform((ClassPath)classPath);
    }

    private static ArtifactCollection getInstrumentedExternalDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(it -> it.attribute(INSTRUMENTED_ATTRIBUTE, (Object)INSTRUMENTED_EXTERNAL_DEPENDENCY_ATTRIBUTE));
            config.componentFilter(DefaultScriptClassPathResolver::isExternalDependency);
        }).getArtifacts();
    }

    private static boolean isGradleApi(ComponentIdentifier componentId) {
        if (componentId instanceof OpaqueComponentIdentifier) {
            DependencyFactoryInternal.ClassPathNotation classPathNotation = ((OpaqueComponentIdentifier)componentId).getClassPathNotation();
            return GRADLE_API_NOTATIONS.contains((Object)classPathNotation);
        }
        return false;
    }

    private static boolean isExternalDependency(ComponentIdentifier componentId) {
        return !DefaultScriptClassPathResolver.isGradleApi(componentId) && !DefaultScriptClassPathResolver.isProjectDependency(componentId);
    }

    private static boolean isProjectDependency(ComponentIdentifier componentId) {
        return componentId instanceof ProjectComponentIdentifier;
    }

    private static ArtifactCollection getInstrumentedProjectDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(it -> it.attribute(INSTRUMENTED_ATTRIBUTE, (Object)INSTRUMENTED_PROJECT_DEPENDENCY_ATTRIBUTE));
            config.componentFilter(DefaultScriptClassPathResolver::isProjectDependency);
        }).getArtifacts();
    }

    private static ClassPath combineToClasspath(Configuration classpathConfiguration, ArtifactCollection externalDependencies, ArtifactCollection projectDependencies) {
        Set originalArtifacts = classpathConfiguration.getIncoming().artifactView(config -> config.componentFilter(id -> !DefaultScriptClassPathResolver.isGradleApi(id))).getArtifacts().getArtifacts();
        List identifiers = originalArtifacts.stream().map(x$0 -> OriginalArtifactIdentifier.of(x$0)).distinct().collect(Collectors.toList());
        Ordering ordering = Ordering.explicit(identifiers);
        List classpath = Stream.concat(externalDependencies.getArtifacts().stream(), projectDependencies.getArtifacts().stream()).map(ClassPathTransformedArtifact::ofTransformedArtifact).sorted((first, second) -> ordering.compare((Object)((ClassPathTransformedArtifact)first).originalIdentifier, (Object)((ClassPathTransformedArtifact)second).originalIdentifier)).map(artifact -> ((ClassPathTransformedArtifact)artifact).file).collect(Collectors.toList());
        return DefaultClassPath.of(classpath);
    }

    private static class OriginalArtifactIdentifier {
        private final String originalFileName;
        private final ComponentIdentifier componentIdentifier;

        private OriginalArtifactIdentifier(String originalFileName, ComponentIdentifier componentIdentifier) {
            this.originalFileName = originalFileName;
            this.componentIdentifier = componentIdentifier;
        }

        private static OriginalArtifactIdentifier of(ResolvedArtifactResult artifact) {
            if (artifact.getId() instanceof TransformedComponentFileArtifactIdentifier) {
                TransformedComponentFileArtifactIdentifier identifier = (TransformedComponentFileArtifactIdentifier)artifact.getId();
                return new OriginalArtifactIdentifier(identifier.getOriginalFileName(), identifier.getComponentIdentifier());
            }
            return new OriginalArtifactIdentifier(artifact.getFile().getName(), artifact.getId().getComponentIdentifier());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OriginalArtifactIdentifier that = (OriginalArtifactIdentifier)o;
            return Objects.equals(this.originalFileName, that.originalFileName) && Objects.equals(this.componentIdentifier, that.componentIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.originalFileName, this.componentIdentifier);
        }
    }

    private static class ClassPathTransformedArtifact {
        private final File file;
        private final OriginalArtifactIdentifier originalIdentifier;

        private ClassPathTransformedArtifact(File file, OriginalArtifactIdentifier originalIdentifier) {
            this.file = file;
            this.originalIdentifier = originalIdentifier;
        }

        public static ClassPathTransformedArtifact ofTransformedArtifact(ResolvedArtifactResult transformedArtifact) {
            Preconditions.checkArgument((boolean)(transformedArtifact.getId() instanceof TransformedComponentFileArtifactIdentifier));
            return new ClassPathTransformedArtifact(transformedArtifact.getFile(), OriginalArtifactIdentifier.of(transformedArtifact));
        }
    }
}

